A simple, but very useful feature of Bonnie is multistage commands, which allow you to run multiple commands in series.

```toml
version = "0.3.2"

[scripts]
test = [
	"echo 1",
	"echo 2",
	"echo 3"
]
```

```
bonnie test	# 1
		# 2
		# 3
```

That example mostly speaks for itself. Wherever you can define a traditional string command, you can define that command as an array of commands instead if you want.

Multistage commands are resolved to a single command, with each stage separated by the shell's set delimiter. They will return the exit code of the last-executed command. For example, if you're on MacOS or Linux, `sh` will be used with the `&&` delimiter. On Windows, Windows PowerShell will be used with the `;` delimiter. This can be customized with the shell, which you can read more about [here](./Custom-Shells). To use more complex logic for command progression, you'll need _ordered subcommands_, which you can read more about [here](./Getting-Started-with-Bones).

Note: before v0.3.1, multistage commands ran in different shells, entirely independently. As of v0.3.1, this is no longer the case, and commands are chained together as explained above.
